#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <locale.h>
#include <string.h>

#define NUM_MAX 100 // nmero mximo de alimentos cadastrados permitidos

typedef struct Alimento {
    int ocupado;
	char nome[101];
	int quantidade;
	char validade[11];
	int dia, mes, ano;
} Alimento;

int main()
{
    Alimento vetor_alimento[NUM_MAX]; //cria um vetor com capacidade de armazenar os dados de 100 alimentos
    int total_alimento = 0; //guarda o total de alimentos cadastradas

    //muda a localizao para Portugus do Brasil
    setlocale(LC_ALL, "portuguese");
    system("chcp 1252 > null");

    //variaveis utilizadas para controlar o loop de execuo do programa
    int sair = 0;   //controla quando o program deve ser encerrao
    int opcao;      //guarda a opo escolhida pelo usurio no menu de opo
    int erro;       //indicador de erro usado na leitura de valores do teclado
    int continuar;  //controla se o usurio quer: cadastrar, pesquisar, ou remover um alimento;
    char ch;        //usado no controle de opes "sim" ou "no"

    //inicializa o vetor de alimentos - livres / desocupados
    for(int i=0; i < NUM_MAX; i++)
    {
        //marca a posio como livre/desocupada, ou seja, pode receber os dados de um alimento!
        vetor_alimento[i].ocupado = 0;
    }

    //variveis utilizadas para fazer a leitura dos dados do alimento do teclado!
	char nome[101];
	int quantidade;
	int dia, mes, ano;
	char validade[11];
    int idxPesquisa = -1; //guarda o indice de: alimento pesquisado - alimento que ser removida

    //loop de execuo do programa
    do {
        //TELA DE OPES
        system("cls");
        printf("Menu de Opes do Estoque de Alimentos \n");
        printf("1 - Cadastrar \n");
        printf("2 - Pesquisar\n");
        printf("3 - Remover \n");
        printf("4 - Relatrio do estoque\n");
        printf("5 - Sair \n\n");

        printf("Escolha uma opo: "); //faz a leitura da opo escolhida
        erro = scanf("%d", &opcao);

        //verifica se houve uma falha na leitura do scanf
        if(erro != 1) {
            fflush(stdin); //limpa o buffer do tecaldo (windows)
            opcao = -1; //como teve uma falha na leitura, marca uma opo invlida
        }

        //verifica qual opo foi escolhida
        switch(opcao)
        {
            //TELA DE CADASTRO
            case 1:
                do {
                    system("cls");
                    printf("1 - Cadastrar \n");

                    //verifica se o cadastro chegou na capacidade mxima
                    if(total_alimento >= NUM_MAX)
                    {
                        //indica que o cadastro j est cheio
                        printf("\nERRO: O cadastro j atingiu sua capacidade mxima de 100 alimentos!\n");
                        system("pause");
                        break; //encerra o lao do-while
                    }

                    //FAZ A ENTRADA DO NOME
                    do
                    {
                        erro = 0; //marca que ainda no ocorreu um erro

                        printf("\nDigite o nome: ");
                        scanf(" %100[^\n]", nome);

                        fflush(stdin); // limpa o buffer do teclado aps a leitura

                        //o nome pode ter no mximo 100 caracteres e no mnimo 2 caracteres
                        if(strlen(nome) > 100)
                        {
                            erro = 1; //marca a ocorrncia de um erro
                            printf("ERRO: O nome do alimento deve possuir no mximo 100 (cem) carracteres!\n");
                        }
                        if(strlen(nome) < 2) {
                            erro = 1; //marca a ocorrncia de um erro
                            printf("ERRO: O nome do alimento deve possuir pelo menos 2 (dois) carracteres!\n");
                        }
                    } while(erro == 1); //FIM DA ENTRADA DO NOME

                    //FAZ A ENTRADA DA QUANTIDADE
                    do
                    {
                        printf("\nDigite a quantidade: ");
                        erro = scanf("%d", &quantidade);

                        fflush(stdin); //limpa o buffer do teclado para o caso do scanf falhar, ou o usurio digitar alguma coisa aps o nmero inteiro

                        //verifica se houve um erro de leitua do scanf
                        if(erro != 1)
                        {
                            printf("ERRO: Digite um valor inteiro vlido!\n");
                        }
                    } while(erro != 1); //FIM DA ENTRADA DA QUANTIDADE


                    //FAZ A ENTRADA DA VALIDADE
                    do
                    {
                        erro = 0; //marca que ainda no ocorreu um erro

                        printf("\nDigite a validade (xx/xx/xxxx): ");
                        scanf(" %10[^\n]", validade);

                        fflush(stdin); //limpa o buffer do teclado para o caso do scanf falhar, ou o usurio digitar alguma coisa aps o nmero inteiro

                        //a validade pode ter no mximo 10 caracteres e deve conter esse formato: xx/xx/xxxx
                        if((strlen(validade) != 10) || (validade[2] != '/' || validade[5] != '/'))
                        {
                            erro = 1; //marca a ocorrncia de um erro
                            printf("ERRO 1: A validade deve possuir 10 caracteres e no formato indicado!\n");
                        }

                        //verifica se a data  vlida
                        if (sscanf(validade, "%d/%d/%d", &dia, &mes, &ano) != 3) {
                            erro = 1;
                            printf("ERRO 2: Deve ser informada no formato xx/xx/xxxx!\n");
                        }

                        if ((dia < 1 || dia > 31) || (mes < 1 || mes > 12) || (ano < 2020 || ano > 2100)) {
                            erro = 1;
                            printf("ERRO 3: Validade invlida!\n");
                        }
                    }while(erro == 1); //FIM DA ENTRADA DA VALIDADE

                    idxPesquisa = -1;  //indica que por enquanto no encontrou ninguem com o mesmo nome

                    //verifica se j existe um alimento cadastrada com o mesmo nome
                    for(int i = 0; i < NUM_MAX; i++)
                    {
                        //compara as strings, se encontrar com o mesmo nome
                        if(strcmp(vetor_alimento[i].nome, nome) == 0)
                        {
                            idxPesquisa = i; //indice do alimento com o mesmo nome no vetor de cadastro
                            break;
                        }
                    }

                    //caso o idxPesquisa seja diferente de -1, quer dizer que encontrou um alimento com o nome igual no cadastro.
                    if(idxPesquisa != -1)
                    {
                        //indica que j existe um alimento com o mesmo nome no cadastro
                        printf("\nErro: No foi possvel inserir os dados pois j existe um alimento com o mesmo nome no cadastro:\v");

                        printf("\nAlimento com o mesmo nome: \n");
                        printf("Nome:         %s\n", vetor_alimento[idxPesquisa].nome);
                        printf("Quantidade:   %d\n", vetor_alimento[idxPesquisa].quantidade);
                        printf("Validade:     %s\n\n",vetor_alimento[idxPesquisa].validade);
                        system("pause");
                    }

                    //no encontrou um alimento j cadastrada com o mesmo nome!
                    else {
                        //procura um elemento livre (no ocupado) no vetor de alimentos!
                        for(int i = 0; i < NUM_MAX; i++)
                        {
                            //encontrou uma posio livre
                            if(vetor_alimento[i].ocupado == 0)
                            {
                                vetor_alimento[i].ocupado = 1; //marca a posio do vetor como ocupada

                                //insere os dados do alimento no vetor !!!
                                strcpy(vetor_alimento[i].nome, nome);
                                vetor_alimento[i].quantidade = quantidade;
                                strcpy(vetor_alimento[i].validade, validade);

                                total_alimento = total_alimento + 1; //incrementa a variavel global que contem o total de alimentos cadastrados

                                printf("\nDados cadastrados com sucesso! \n");
                                system("pause");
                                break;
                            }
                        }
                    }

                    //mostra uma mensagem na tela perguntando se o usurio deseja cadastrar outro alimento
                    do{
                        printf("\nGostaria de cadastrar outro alimento? (s/n): ");
                        scanf(" %c", &ch); //faz a leitura da opo (caractere) escolhida

                        fflush(stdin); //limpa o buffer do tecaldo (windows) se o usurio digitar mais de um caracteres o buffer ficar com lixo (por isso limpa)

                        ch = toupper(ch); //converte o caractere lido para maiusculo
                    }while(!(ch == 'S' || ch == 'N')); //caso o usurio no digite 's' ou 'n'

                    //o usurio decidiu cadastrar outra pessoa
                    if(ch == 'S') {
                        continuar = 1;
                    }
                    //o usrio no quer cadastrar outra pessoa
                    else{
                        continuar = 0;
                    }
                } while(continuar == 1);
            break;

            //TELA DE PESQUISA
            case 2:
                do{
                    system("cls");
                    printf("2 - Pesquisar \n");

                    //ENTRADA DO NOME DO ALIMENTO
                    do {
                        erro = 0; //marca que por enquanto no houve erro

                        printf("\nDigite o nome: "); //ler no mximo 100 caracteres
                        scanf(" %100[^\n]", nome);

                        fflush(stdin); // limpa lixo no buffer do teclado
                    } while(erro == 1); // FIM ENTRADA DO NOME

                    //indica que por enquanto no encontrou nenhum alimento com o nome pesquisado
                    idxPesquisa = -1;

                    //pesquisa um alimento no cadastro a partir do nome, percorre todo o vetor com o cadastro dos alimentos
                    for(int i = 0; i < NUM_MAX; i++){
                        //verifica se est ocupado com os dados de um alimento
                        if(vetor_alimento[i].ocupado == 1) {
                            //verifica se o nome do alimento  igual ao nome pesquisado
                            if(strcmp(vetor_alimento[i].nome, nome) == 0){
                                //guarda o indice do alimento que tem o nome igual ao nome pesquisado
                                idxPesquisa = i;
                                break; //encontrou o alimento, encerra o lao de busca
                            }
                        }
                    }

                    //caso o indice seja diferente de -1, quer dizer que encontrou um alimento com o nome igual ao nome pesquisado.
                    if(idxPesquisa != -1) {
                        printf("\nAlimento Encontrado: \n");
                        printf("Nome:         %s\n", vetor_alimento[idxPesquisa].nome);
                        printf("Quantidade:   %d\n", vetor_alimento[idxPesquisa].quantidade);
                        printf("Validade:     %s\n\n", vetor_alimento[idxPesquisa].validade);
                        system("pause");
                    }
                    //no encontrou um alimento
                    else {
                        printf("\nNo foi encontrado um alimento com o nome informado!\n\n");
                        system("pause");
                    }

                    //mostra uma mensagem na tela perguntando se o usurio deseja pesquisar outro alimento
                    do{
                        printf("\nGostaria de pesquisar outro alimento?  (s/n): ");
                        scanf(" %c", &ch); //faz a leitura da opo (caractere) escolhida

                        fflush(stdin); //limpa o buffer do tecaldo (windows) se o usurio digitar mais de um caracteres o buffer ficar com lixo (por isso eu limpo)

                        ch = toupper(ch); //converte o caractere lido para maiusculo
                    } while(!(ch == 'S' || ch == 'N'));

                    //o usurio decidiu pesquisar outro alimento
                    if(ch == 'S') {
                        continuar = 1;
                    }
                    //o usrio no quer pesquisar outro alimento
                    else{
                        continuar = 0;
                    }
                } while(continuar == 1);
            break;

            // TELA DE REMOO
            case 3:
                do {
                    system("cls");
                    printf("3 - Remover \n\n");

                    //ENTRADA DO NOME DO ALIMENTO
                    do {
                        erro = 0; //marca que por enquanto no houve erro

                        printf("\nDigite o nome: ");
                        scanf(" %100[^\n]", nome);

                        fflush(stdin); // limpa lixo no buffer do teclado!!!
                    } while(erro == 1); // FIM ENTRADA DO NOME DO ALIMENTO

                    idxPesquisa = -1; //indica que por enquanto no encontrou ninguem com o nome pesquisado

                    //percorre todo o vetor com os alimentos cadastradas
                    for(int i = 0; i < NUM_MAX; i++) {
                        //verifica apenas elementos do vetor de alimentos que realmente esto ocupados
                        if(vetor_alimento[i].ocupado == 1) {
                            //verifica se o nome do alimento  igual ao nome passado como parmentro
                            if(strcmp(vetor_alimento[i].nome, nome) == 0){
                                //encontrou o alimento, ento tem que decrementar o contador de alimentos
                                total_alimento = total_alimento - 1;
                                //marca o espao/elemento do vetor como livre, ou seja pode ser reutilizado para guardar os dados de outro alimento!
                                vetor_alimento[i].ocupado = 0;
                                //guarda o indice do alimento que tem o nome igual ao nome pesquisado
                                idxPesquisa = i;
                                break;
                            }
                        }
                    }

                    //caso o indice seja diferente de -1, quer dizer que encontrou um alimento com o nome igual ao nome pesquisado.
                    if(idxPesquisa != -1) {
                        printf("\nAlimento removido com sucesso!\n");
                    }
                    else {
                        printf("\nNo foi possvel remover o alimento do cadastro!\n");
                    }
                    system("pause");

                    //mostra uma mensagem na tela perguntando se o usurio deseja remover outro alimento
                    do {
                        printf("\nGostaria de remover outro alimento?  (s/n): ");
                        scanf(" %c", &ch); //faz a leitura da opo (caractere) escolhida

                        fflush(stdin); //limpa com lixo

                        ch = toupper(ch); //converte o caractere lido para maiusculo
                    } while(!(ch == 'S' || ch == 'N')); //caso o usurio no digite 's' ou 'n'

                    //o usurio decidiu pesquisar outro alimento
                    if(ch == 'S') {
                        continuar = 1;
                    }
                    //o usrio no quer pesquisar outro alimento
                    else {
                        continuar = 0;
                    }
                }while(continuar);
            break;

            // TELA DE RELATRIO
            case 4:
                system("cls");
                printf("4 - Relatrio \n\n");
                printf("Total de Alimentos Cadastrados: %d\n\n", total_alimento);

                //percorre todo o vetor com o cadastro dos alimentos
                for(int i = 0; i < NUM_MAX; i++){
                    if(vetor_alimento[i].ocupado == 1) {
                        printf("Nome:         %s\n", vetor_alimento[i].nome);
                        printf("Quantidade:   %d\n", vetor_alimento[i].quantidade);
                        printf("Validade:     %s\n\n", vetor_alimento[i].validade);
                    }
                }
                system("pause");
            break;

            // TELA ENCERRAR APLICAO
            case 5:
                system("cls");
                printf("5 - Sair \n\n");

                do{
                    printf("Deseja mesmo sair?  (s/n): ");
                    scanf(" %c", &ch); //faz a leitura da opo (caractere) escolhida

                    fflush(stdin); // limpa com lixo

                    ch = toupper(ch); //converte o caractere lido para maiusculo

                    //caso o usurio escolha 'S', isto  sair
                    if(ch == 'S') {
                        //marca a varivel sair como 1 para encerrar o loop do programa!!!
                        sair = 1;
                    }
                //caso o usurio no digite 's' ou 'n'
                }while(!(ch == 'S' || ch == 'N'));
            break;

            // TRATAMENTO DE OPO INVLIDA
            default:
                printf("\nOpo Invlida !!! \n"); //mostra uma mensagem informando que a opo escolhida do "Menu de Opes"  invlida!
                system("pause");
        }
    } while (sair == 0);

    system("cls");
    printf("\nFim da execuo do programa!\n");

    return 0;
}
